/**************************************************************************/
/*                                                                        */
/* Module:             INTS_DOS.C                                         */
/*                                                                        */
/* Function:           Interactive Service Interface                      */
/*                     -- Sample declaration routines                     */
/*                                                                        */
/* Author:             W. Reichert, D.3228                                */
/*                                                                        */
/* Date created:       1991-03-06                                         */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/

/**************************************************************************/
/* Include files                                                          */
/**************************************************************************/

#define  INCL_DOS
#include <OS2.H>               /* for DOS API calls                       */
#include <stdlib.h>            /* for C call: system()                    */
#include <string.h>            /* for memcpy used by SetMem               */

#include "INTSRV.H"
#include "INTS_INI.H"
 
#ifndef __32BIT__              /* 16-Bit: API RC is of type USHORT        */
typedef unsigned short APIRET; /* 32-Bit: APIRET is defined in OS2DEF.H   */
#endif

/****** ISIDosBeep() ******************************************************/

USHORT ISIDosBeep()
{
    USHORT usFrequency;        /* Define parameters for function call ... */
    USHORT usDuration;
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_USHORT, "Frequency (Hz)", &usFrequency, 0, 0);
    GetValue(TYPE_USHORT, "Duration (ms)",  &usDuration,  0, 0);

    /* Call the function */

    COND_SECT("DosBeep");
      apiRC = DosBeep(usFrequency, usDuration);
    END_COND_SECT;

    /* Show return code (and output values, if any) */

    ShowValue(TYPE_USHORT, "DosBeep()", &apiRC, 0L, 0);

    return 0;
}

/****** ISIDosChDir() *****************************************************/

USHORT ISIDosChDir()
{
    PSZ    pszDirName;         /* Define parameters for function call     */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_PSZ,    "DirName", &pszDirName, 0, 0);

    /* Call the function */

    COND_SECT("DosChDir");
#ifdef __32BIT__
      apiRC = DosChDir(pszDirName);
#else
      apiRC = DosChDir(pszDirName, 0L);
#endif
    END_COND_SECT;

    /* Show return code (and output values, if any) */

    ShowValue(TYPE_USHORT, "DosChDir()", &apiRC, 0L, 0);

    return 0;
}

/****** ISIDosSelectDisk() ************************************************/

USHORT ISIDosSelectDisk()
{
    USHORT usDriveNumber;      /* Define parameters for function call     */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_USHORT, "DriveNumber", &usDriveNumber, 0, 0);

    /* Call the function */

    COND_SECT("DosSelectDisk");
      apiRC = DosSelectDisk(usDriveNumber);
    END_COND_SECT;

    /* Show return code (and output values, if any) */

    ShowValue(TYPE_USHORT, "DosSelectDisk()", &apiRC, 0L, 0);

    return 0;
}

/****** ISIDosExecPgm() ***************************************************/

USHORT ISIDosExecPgm()
{
    PCHAR  pchObjNameBuf = NULL;       /* Object name buffer              */
    USHORT usObjNameBufLen;            /* Object name buffer length       */
    USHORT usExecFlags;                /* Execution flags                 */
    PSZ    pszArgPointer;              /* Argument string                 */
    PSZ    pszEnvPointer;              /* Environment string              */
    RESULTCODES stuReturnCodes;        /* Termination codes               */
    PSZ    pszPgmPointer;              /* Program file name               */

    APIRET apiRC = 0;                  /* Return code of function call    */

    /* Get length of object name buffer and allocate the requested buffer */

    GetValue(TYPE_USHORT, "ObjNameBufLen", &usObjNameBufLen, 0, 0);
    GetBuffer(&pchObjNameBuf, (ULONG) usObjNameBufLen, 0L);

    /* Get other parameters interactively */

    GetValue(TYPE_USHORT, "ExecFlags",     &usExecFlags,    0, 0);
    GetValue(TYPE_PSZ,    "ArgPointer",    &pszArgPointer,  0, 0);
    GetValue(TYPE_PSZ,    "EnvPointer",    &pszEnvPointer,  0, 0);
    GetValue(TYPE_PSZ,    "PgmPointer",    &pszPgmPointer,  0, 0);

    /* Call the function */

    COND_SECT("DosExecPgm");
      apiRC = DosExecPgm(pchObjNameBuf, usObjNameBufLen, usExecFlags,
                         pszArgPointer, pszEnvPointer, &stuReturnCodes,
                         pszPgmPointer);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosExecPgm()", &apiRC, 0L, 0);
    ShowValue(TYPE_PCHAR,  "ObjNameBuf",   &pchObjNameBuf,
                                                (ULONG) usObjNameBufLen, 0);
    ShowValue(TYPE_USHORT, "CodeTerminate",&stuReturnCodes.codeTerminate,
                                                                      0L,0);
    ShowValue(TYPE_USHORT, "CodeResult",   &stuReturnCodes.codeResult,0L,0);

    GetBuffer(&pchObjNameBuf, 0L, 0L); /* Free buffer                     */

    return 0;
}

/****** ISIDosSleep() *****************************************************/

USHORT ISIDosSleep()
{
    ULONG  ulTimeInterv;       /* Time interval (in milliseconds)         */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_ULONG, "TimeInterval (ms)", &ulTimeInterv, 0, 0);

    /* Call the function */

    COND_SECT("DosSleep");
      apiRC = DosSleep(ulTimeInterv);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_USHORT, "DosSleep()", &apiRC, 0L, 0);

    return 0;
}

/****** ISIDosLoadModule() ************************************************/

USHORT ISIDosLoadModule()
{
    PCHAR  pchObjNameBuf = NULL;       /* Object name buffer              */
    USHORT usObjNameBufLen;            /* Object name buffer length       */
    PSZ    pszModuleName;              /* Module Name                     */
    HMODULE hmodModuleHandle = 0;      /* Module Handle                   */

    APIRET apiRC = 0;                  /* Return code of function call    */

    /* Get length of object name buffer and allocate the requested buffer */

    GetValue(TYPE_USHORT, "ObjNameBufLen", &usObjNameBufLen, 0, 0);
    GetBuffer(&pchObjNameBuf, (ULONG) usObjNameBufLen, 0L);

    /* Get other parameters interactively */

    GetValue(TYPE_PSZ,    "ModuleName",    &pszModuleName,  0, 0);

    /* Call the function */

    COND_SECT("DosLoadModule");
      apiRC = DosLoadModule(pchObjNameBuf, usObjNameBufLen,
                            pszModuleName, &hmodModuleHandle);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosLoadModule()", &apiRC, 0L, 0);
    ShowValue(TYPE_HMODULE,"ModuleHandle", &hmodModuleHandle, 0L, 0);
    ShowValue(TYPE_PCHAR,  "ObjNameBuf",   &pchObjNameBuf,
                                                (ULONG) usObjNameBufLen, 0);

    GetBuffer(&pchObjNameBuf, 0L, 0L); /* Free buffer                     */

    return 0;
}

/****** ISIDosFreeModule() ************************************************/

USHORT ISIDosFreeModule()
{
    HMODULE hmodModuleHandle;          /* Module Handle                   */

    APIRET apiRC = 0;                  /* Return code of function call    */

    /* Get parameter interactively */

    GetValue(TYPE_HMODULE, "ModuleHandle", &hmodModuleHandle, 0, 0);

    /* Call the function */

    COND_SECT("DosFreeModule");
      apiRC = DosFreeModule(hmodModuleHandle);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_USHORT, "DosFreeModule()", &apiRC, 0L, 0);

    return 0;
}
 
/**************************************************************************/
/* 16 Bit only DOS Calls                                                  */
/**************************************************************************/
#ifndef __32BIT__
 
/****** ISIDosGetPID() ****************************************************/

USHORT ISIDosGetPID()
{
    PIDINFO   stuPIDInfo;      /* Structure: Process info                 */
    USHORT    apiRC = 0;       /* Return code                             */

    /* Call the function */

    COND_SECT("DosGetPID");
      apiRC = DosGetPID(&stuPIDInfo);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_USHORT, "DosGetPID()",  &apiRC,                 0L, 0);
    ShowValue(TYPE_PID,    "  pidCurrent", &stuPIDInfo.pid,       0L, 0);
    ShowValue(TYPE_TID,    "  tidCurrent", &stuPIDInfo.tid,       0L, 0);
    ShowValue(TYPE_PID,    "  pidParent",  &stuPIDInfo.pidParent, 0L, 0);

    return 0;
}

/****** ISIDosGetInfoSeg() ************************************************/

USHORT ISIDosGetInfoSeg()
{
    PGINFOSEG pGInfo;          /* Structure pointer: global info segment  */
    PLINFOSEG pLInfo;          /* Structure pointer: local info segment   */
    SEL       selGInfo = NULL; /* Selector (returned by DosGetInfoSeg)    */
    SEL       selLInfo = NULL; /* Selector (returned by DosGetInfoSeg)    */
    USHORT    apiRC = 0;       /* Return code                             */

    BOOL fGInfo;               /* GlobalInfoSeg?                          */
    BOOL fLInfo;               /* LocalInfoSeg?                           */

    GetValue(TYPE_BOOL, "GlobalInfoSeg?", &fGInfo, 0, 0);
    GetValue(TYPE_BOOL, "LocalInfoSeg?",  &fLInfo, 0, 0);

    COND_SECT("DosGetInfoSeg");
      apiRC = DosGetInfoSeg(&selGInfo, &selLInfo);
    END_COND_SECT;

    ShowValue(TYPE_USHORT, "DosGetInfoSeg()", &apiRC, 0L, 0);

    if (fGInfo && !apiRC)               /* Show global info segment */
    {
      pGInfo = MAKEPGINFOSEG(selGInfo);
      ShowValue(TYPE_PVOID ,"GINFOSEG",             &pGInfo,                     0L, 0);
      ShowValue(TYPE_ULONG, "  time",               &pGInfo->time,               0L, 0);
      ShowValue(TYPE_ULONG, "  msecs",              &pGInfo->msecs,              0L, 0);
      ShowValue(TYPE_UCHAR, "  hour",               &pGInfo->hour,               0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  minutes",            &pGInfo->minutes,            0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  seconds",            &pGInfo->seconds,            0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  hundredths",         &pGInfo->hundredths,         0L, DISPLAY_INTEGER);
      ShowValue(TYPE_USHORT,"  timezone",           &pGInfo->timezone,           0L, 0);
      ShowValue(TYPE_USHORT,"  cusecTimerInterval", &pGInfo->cusecTimerInterval, 0L, 0);
      ShowValue(TYPE_UCHAR, "  day",                &pGInfo->day,                0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  month",              &pGInfo->month,              0L, DISPLAY_INTEGER);
      ShowValue(TYPE_USHORT,"  year",               &pGInfo->year,               0L, 0);
      ShowValue(TYPE_UCHAR, "  weekday",            &pGInfo->weekday,            0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  uchMajorVersion",    &pGInfo->uchMajorVersion,    0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  uchMinorVersion",    &pGInfo->uchMinorVersion,    0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  chRevisionLetter",   &pGInfo->chRevisionLetter,   0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  uchCurrent",         &pGInfo->sgCurrent,          0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  sgMax",              &pGInfo->sgMax,              0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  cHugeShift",         &pGInfo->cHugeShift,         0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  fProtectModeOnly",   &pGInfo->fProtectModeOnly,   0L, DISPLAY_INTEGER);
      ShowValue(TYPE_USHORT,"  pidForeground",      &pGInfo->pidForeground,      0L, 0);
      ShowValue(TYPE_UCHAR, "  fDynamicSched",      &pGInfo->fDynamicSched,      0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  csecMaxWait",        &pGInfo->csecMaxWait,        0L, DISPLAY_INTEGER);
      ShowValue(TYPE_USHORT,"  cmsecMinSlice",      &pGInfo->cmsecMinSlice,      0L, 0);
      ShowValue(TYPE_USHORT,"  cmsecMaxSlice",      &pGInfo->cmsecMaxSlice,      0L, 0);
      ShowValue(TYPE_USHORT,"  bootdrive",          &pGInfo->bootdrive,          0L, 0);
      ShowValue(TYPE_ACHAR, "  amecRAS",            &pGInfo->amecRAS[0], 32L, DISPLAY_HEX);
      ShowValue(TYPE_UCHAR, "  csgWindowableVioMax",&pGInfo->csgWindowableVioMax,0L, DISPLAY_INTEGER);
      ShowValue(TYPE_UCHAR, "  csgPMMax",           &pGInfo->csgPMMax,           0L, DISPLAY_INTEGER);
    }

    if (fLInfo && !apiRC)               /* Show local info segment */
    {
      pLInfo = MAKEPLINFOSEG(selLInfo);
      ShowValue(TYPE_PVOID ,"LINFOSEG",        &pLInfo,                0L, 0);
      ShowValue(TYPE_USHORT,"  pidCurrent",    &pLInfo->pidCurrent,    0L, 0);
      ShowValue(TYPE_USHORT,"  pidParent",     &pLInfo->pidParent,     0L, 0);
      ShowValue(TYPE_USHORT,"  prtyCurrent",   &pLInfo->prtyCurrent,   0L, 0);
      ShowValue(TYPE_USHORT,"  tidCurrent",    &pLInfo->tidCurrent,    0L, 0);
      ShowValue(TYPE_USHORT,"  usCurrent",     &pLInfo->sgCurrent,     0L, 0);
      ShowValue(TYPE_UCHAR, "  rfProcStatus",  &pLInfo->rfProcStatus,  0L, DISPLAY_INTEGER);
      ShowValue(TYPE_BOOL,  "  fForeground",   &pLInfo->fForeground,   0L, 0);
      ShowValue(TYPE_UCHAR, "  typeProcess",   &pLInfo->typeProcess,   0L, DISPLAY_INTEGER);
      ShowValue(TYPE_USHORT,"  selEnvironment",&pLInfo->selEnvironment,0L, DISPLAY_HEX);
      ShowValue(TYPE_USHORT,"  offCmdLine",    &pLInfo->offCmdLine,    0L, DISPLAY_HEX);
      ShowValue(TYPE_USHORT,"  cbDataSegment", &pLInfo->cbDataSegment, 0L, 0);
      ShowValue(TYPE_USHORT,"  cbStack",       &pLInfo->cbStack,       0L, 0);
      ShowValue(TYPE_USHORT,"  cbHeap",        &pLInfo->cbHeap,        0L, 0);
      ShowValue(TYPE_USHORT,"  hmod",          &pLInfo->hmod,          0L, DISPLAY_HEX);
      ShowValue(TYPE_USHORT,"  selDS",         &pLInfo->selDS,         0L, DISPLAY_HEX);
    }
    return 0;
}

/****** ISIDosGetModHandle() **********************************************/

USHORT ISIDosGetModHandle()
{
    PSZ    pszModuleName;              /* Module Name                     */
    HMODULE hmodModuleHandle = 0;      /* Module Handle                   */

    APIRET apiRC = 0;                  /* Return code of function call    */

    /* Get parameters interactively */

    GetValue(TYPE_PSZ,    "ModuleName",    &pszModuleName,  0, 0);

    /* Call the function */

    COND_SECT("DosGetModHandle");
      apiRC = DosGetModHandle(pszModuleName, &hmodModuleHandle);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosGetModHandle()", &apiRC, 0L, 0);
    ShowValue(TYPE_HMODULE,"ModuleHandle", &hmodModuleHandle, 0L, 0);

    return 0;
}

/****** ISIDosGetModName() ************************************************/

USHORT ISIDosGetModName()
{
    HMODULE hmodModuleHandle;          /* Module Handle                   */
    USHORT usNameBufLen;               /* Object name buffer length       */
    PSZ    pszModuleName;              /* Module Name                     */

    APIRET apiRC = 0;                  /* Return code of function call    */

    /* Get parameters interactively; clear and re-size buffer for name */

    GetValue(TYPE_HMODULE,"ModuleHandle",&hmodModuleHandle, 0, 0);
    GetValue(TYPE_USHORT, "NameBufLen",  &usNameBufLen,     0, 0);
    SetValueSize(TYPE_PSZ,"ModuleName",  &pszModuleName,
                                   (ULONG) usNameBufLen+1, 0, CLEAR_BUFFER);

    /* Call the function */

    COND_SECT("DosGetModName");
      apiRC = DosGetModName(hmodModuleHandle, usNameBufLen, pszModuleName);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosGetModName()", &apiRC, 0L, 0);
    ShowValue(TYPE_PSZ,    "ModuleName", &pszModuleName, 0L, 0);
    return 0;
}

/****** ISIDosAllocSeg() **************************************************/

USHORT ISIDosAllocSeg()
{
    USHORT usAllocFlags;       /* Allocation flags                        */
    USHORT usSize;             /* Allocation size                         */
    SEL    selSelector = 0;    /* Segment selector (output)               */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_USHORT, "Size",       &usSize,       0, 0);
    GetValue(TYPE_USHORT, "AllocFlags", &usAllocFlags, 0, 0);

    /* Call the function */

    COND_SECT("DosAllocSeg");
      apiRC = DosAllocSeg(usSize, &selSelector, usAllocFlags);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosAllocSeg()", &apiRC,        0L, 0);
    ShowValue(TYPE_SEL,    "Selector",      &selSelector, 0L, DISPLAY_HEX);

    return 0;
}

/****** ISIDosReallocSeg() ************************************************/

USHORT ISIDosReallocSeg()
{
    USHORT usSize;             /* Allocation size                         */
    SEL    selSelector;        /* Segment selector                        */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_USHORT, "Size",     &usSize,      0, 0);
    GetValue(TYPE_SEL,    "Selector", &selSelector, 0, DISPLAY_HEX);

    /* Call the function */

    COND_SECT("DosReallocSeg");
      apiRC = DosReallocSeg(usSize, selSelector);
    END_COND_SECT;

    /* Show return code and output values */

    ShowValue(TYPE_USHORT, "DosReallocSeg()", &apiRC, 0L, 0);

    return 0;
}

/****** ISIDosFreeSeg() ***************************************************/

USHORT ISIDosFreeSeg()
{
    SEL    selSelector = 0;    /* Segment selector                        */
    APIRET apiRC = 0;          /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_SEL, "Selector", &selSelector, 0, DISPLAY_HEX);

    /* Call the function */

    COND_SECT("DosFreeSeg");
      apiRC = DosFreeSeg(selSelector);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_USHORT, "DosFreeSeg()", &apiRC, 0L, 0);

    return 0;
}
#endif /* 16BIT only */

/**************************************************************************/
/* C Functions                                                            */
/**************************************************************************/
 
/****** ISIsystem() *******************************************************/

USHORT ISIsystem()             /* Standard C call: system()               */
{
    PSZ    pszCommand;         /* System command                          */
    INT    iRC = 0;            /* Return code of function call            */

    /* Get parameters interactively */

    GetValue(TYPE_PSZ, "Command", &pszCommand, 0, 0);

    /* Call the function */

    COND_SECT("system");
      iRC = system(pszCommand);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_INT, "system()", &iRC, 0L, 0);

    return 0;
}

/****** ISImalloc() *******************************************************/

USHORT ISImalloc()             /* Standard C call: malloc()               */
{
    UINT   uiSize;             /* Size to be allocated                    */
    PVOID  pAddress = NULL;    /* Address returned                        */

    /* Get parameters interactively */

    GetValue(TYPE_UINT, "mallocSize", &uiSize, 0, 0);

    /* Call the function */

    COND_SECT("malloc");
      pAddress = malloc(uiSize);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_PVOID, "malloc()",   &pAddress, 0L, DISPLAY_HEX);
    SetValue(TYPE_PVOID,  "MemAddress", &pAddress, 0L, 0);

    return 0;
}

/****** ISIfree() *********************************************************/

USHORT ISIfree()               /* Standard C call: free()                 */
{
    PVOID  pAddress = NULL;    /* Address returned                        */

    /* Get parameters interactively */

    GetValue(TYPE_PVOID, "MemAddress", &pAddress, 0, DISPLAY_HEX);

    /* Call the function */

    COND_SECT("free");
      (void) free(pAddress);
    END_COND_SECT;

    /* Show return code */

    ShowValue(TYPE_VOID, "free()", "", 0L, NO_SETVALUE);

    return 0;
}

/****** ISIShowMem() ******************************************************/

USHORT ISIShowMem()            /* Show memory contents                    */
{
    PVOID  pMemAddress;        /* Address of memory                       */
    ULONG  ulMemLength;        /* Length to be displayed                  */

    /* Get parameters interactively */

    GetValue(TYPE_PVOID, "MemAddress", &pMemAddress,  0, 0);
    GetValue(TYPE_ULONG, "MemLength",  &ulMemLength,  0, 0);

    /* Use ShowValue to display memory contents */

    COND_SECT("ShowMem");
      ShowValue(TYPE_PCHAR, "MemContents", &pMemAddress, ulMemLength, 0);
    END_COND_SECT;

    return 0;
}

/****** ISISetMem() *******************************************************/

USHORT ISISetMem()             /* Set contents of memory                  */
{
    PVOID  pMemAddress;        /* Address of memory                       */
    PCHAR  pchMemContents;     /* Contents                                */
    ULONG  ulMemLength;        /* Length to be set                        */

    /* Get parameters interactively */

    GetValue(TYPE_PVOID, "MemAddress",  &pMemAddress,               0, 0);
    GetValue(TYPE_PCHAR, "MemContents", &pchMemContents, &ulMemLength, 0);

    /* Call the function */

    COND_SECT("SetMem");
      if (pchMemContents)
          (void) memcpy(pMemAddress, pchMemContents, (size_t) ulMemLength);
    END_COND_SECT;

    return 0;
}
